//	PhysicalFloppy.h
#ifndef _H_PhysicalFloppy
#define _H_PhysicalFloppy

#include "FileSystemTypes.h"

OSErr		GetVolRec(short driveNumS, PhysVolumeRec *volRecP);

OSErr		EjectFloppy(PhysVolumeRec *volRecP);
OSErr		MountPhysicalFloppy(short driveNumS, OSErr mountErr);

OSErr		GetVolBlocks(PhysVolumeRec *volRecP);

#ifndef __68k__
	OSStatus	VolMountEventRefToRec(EventRef eventRef, EventRecord *eventRec);
#endif

OSErr		GetPhysicalBlock(PhysVolumeRec *volRecP, ulong blockL, void *blockP);
OSErr		SetPhysicalBlock(PhysVolumeRec *volRecP, ulong blockL, void *blockP);

#define		kFloppy_BlocksPerTrack		32
OSErr		GetPhysicalTrack(PhysVolumeRec *volRecP, ulong blockL, void *trackP);
OSErr		SetPhysicalTrack(PhysVolumeRec *volRecP, ulong blockL, void *trackP);

OSErr		FormatFloppy(PhysVolumeRec *volRecP, FSType osType);

#endif